//render at 640x480 for book cover for on-line version
//anti-aliasing adaptive threshold 0.2 recursion 2 jitter 0.5
//render at 1900x1425 for 300 dpi cover image
//render at 1680x1050 for desktop picture (16:10)
//render at 640x480 for overhead picture and add alpha channel

#include "colors.inc"
#include "stones1.inc"

//one unit is one yard
#declare hex_diag = 7;
#declare hex_short = 4;
#declare feet = 1/3;
#declare inches = feet/12;

#declare renderAll = true; //28,000K tokens
#declare renderGrass = false; //14,000K tokens
#declare renderTrees = false; //7,000K tokens and they take a long time
#declare renderSky = false; //7,000K tokens

//viewing location
//use zombieView for the cover image, overView for the back cover image
#declare zombieView = 1;
#declare birdView = 2;
#declare overView = 3;
#declare nookView = 4;
#declare houseEastView = 5;
#declare houseFrontView = 6;
#declare houseWestView = 7;
#declare houseRoofView = 8;
#declare viewType = zombieView;

//for storing trace slope in
#declare nvector = <0, 1, 0>;

#include "land.inc"
#include "sky.inc"
#include "house.inc"
#include "bridge.inc"
#include "misc.inc"
//viewpoint is 5 feet above the hill
#declare zombie_loc = <hex_diag, sun_height, -(simple_radius-13)>;
#declare zombie_loc = trace(land, zombie_loc, <0, -1, 0>);
#declare zombie_loc = zombie_loc + <0, 5*feet, 0>;
#declare viewpoint = <-hex_diag*3+3, sun_height, hex_diag*2>;
#declare viewpoint = trace(land, viewpoint, <0, -1, 0>, nvector);

//house location
#declare nook_loc = houseStart + <0*feet, 0, -14*feet>;
#declare nook_loc = trace(land, nook_loc, <0, -1, 0>, nvector)+<0, 5*feet, -50*feet>;
#declare house_look = houseStart + <40*feet, 0, -8*feet>;
#declare house_look = trace(land, house_look, <0, -1, 0>, nvector)+<0, 5*feet, 0>;
background {
	color White
}
global_settings {
	ambient_light .4
	assumed_gamma 1
}

light_source {
	<0.0, sun_height, 0>
	color White
	rotate <-30, 0, 0>
}
#switch (viewType)
	#case (nookView)
		#declare extraSun = nook_loc;
		#break
	#case (houseFrontView)
		#declare house_front_loc = nook_loc+<0, 0, 35>;
		#declare extraSun = house_front_loc;
		#break
#end

#ifdef (extraSun)
	light_source {
		extraSun
		color White
	}
#end
camera {
	perspective 
	
	#switch (viewType)
		#case (overView)
			location <0, sun_height*2, 0>
			look_at <0.0, 0, 0.0>
			#break
		#case  (birdView)
			location <0, 10, -simple_radius+20>
			rotate <0, -20, 0>
			look_at <0, 2, simple_radius>
			#break
		#case (nookView)
			location nook_loc+<0, 3, 8>
			look_at nook_loc+<0, -10, 100>
			#break
		#case (houseEastView)
			location house_look
			look_at house_look+<-100, -8, 0>
			#break
		#case (houseWestView)
			location house_look+<-17*square, 0, 0>
			look_at house_look+<100, -8, 0>
			#break
		#case (houseFrontView)
			location house_front_loc
			look_at nook_loc+<0, -8, -100>
			#break
		#case (houseRoofView)
			location <houseLoc.x, 20, houseLoc.z-3>
			look_at houseLoc+<0, 0, -3>
			#break
		#else
			//by zombie
			location zombie_loc
			look_at viewpoint
	#end

	up y
	right x*image_width/image_height
}

//show where the viewing location is
#if (viewType= overView)
	sphere {
		<0, 0, 0>, 2
		translate zombie_loc
		pigment {
			color Red
		}
	}
	
	sphere {
		<0, 0, 0>, 2
		translate viewpoint
		pigment {
			color White
		}
	}

#end

object { land }

//sky
#ifdef (SkySphere)
	object { SkySphere }
#end
//house
object { house
	translate houseLoc
}

object { bridge
	translate <houseLoc.x, -bridgeRadius, houseLoc.z>
	translate <1, 0, -16>
	translate <0, 5, 0>
}

object { bridge
	rotate <0, 15, 0>
	translate <houseLoc.x, -bridgeRadius, houseLoc.z>
	translate <1, 0, 10>
	translate <0, 4.5, 0>
}

#declare cryptStart = <-39.5, simple_radius, -26.5>;
#declare cryptLoc = trace(land, cryptStart, <0, -1, 0>, nvector);
object { crypt
	translate cryptLoc
}

object { orangeJelly
	translate <-8*hex_diag, 0, .5*hex_diag>
}
object { runepost
	translate runeLocation
}

//Copse of trees with pigasi
#include "copse.inc"

//Bushes
#include "bushes.inc"

/*
//something right next to the house (east side view)
#declare scrubStart = zombie_loc + <-21.5, 0, 33>;
#declare scrubLoc = trace(land, scrubStart, <0, -1, 0>, nvector);
object { runepost
	translate scrubLoc
}
*/